USE SSISDB
GO

/******************************************************
				Execute Success package
******************************************************/
DECLARE @execution_id BIGINT
EXEC [SSISDB].[catalog].[create_execution] 
	@package_name=N'30 Parameterized Package.dtsx'
	, @folder_name=N'Making the Most of the SSIS Catalog'
	, @project_name=N'Making the Most of the Catalog'
	, @use32bitruntime=False, @reference_id=2
	, @execution_id=@execution_id OUTPUT

-- System Params
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id,  @object_type=50, @parameter_name=N'LOGGING_LEVEL', @parameter_value=3
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id,  @object_type=50, @parameter_name=N'SYNCHRONIZED', @parameter_value=1

EXEC [SSISDB].[catalog].[start_execution] @execution_id

WAITFOR DELAY '00:00:03'

IF 7 <> (SELECT status FROM catalog.executions WHERE execution_id = @execution_id)
RAISERROR('The package failed. See the SSIS log for more information.', 16, 1)

GO


/******************************************************
				Execute failure package
******************************************************/

DECLARE @execution_id BIGINT
EXEC [SSISDB].[catalog].[create_execution] 
	@package_name=N'31 Fail.dtsx'
	, @folder_name=N'Making the Most of the SSIS Catalog'
	, @project_name=N'Making the Most of the Catalog'
	, @use32bitruntime=False, @reference_id=2
	, @execution_id=@execution_id OUTPUT

-- System Params
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id,  @object_type=50, @parameter_name=N'LOGGING_LEVEL', @parameter_value=3
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id,  @object_type=50, @parameter_name=N'SYNCHRONIZED', @parameter_value=1

EXEC [SSISDB].[catalog].[start_execution] @execution_id

WAITFOR DELAY '00:00:03'

IF 7 <> (SELECT status FROM catalog.executions WHERE execution_id = @execution_id)
RAISERROR('The package failed. See the SSIS log for more information.', 16, 1)

